unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Winsock, StdCtrls, Mask, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Button2: TButton;
    Button3: TButton;
    Panel1: TPanel;
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function AdresIP(var nazwaKomputera :String;inicjacja :Boolean = True) :String;
var
  //Biblioteka Winsock
  wVersionRequested:WORD;
  wsaData:TWSAData;
  //Struktury potrzebne do odczytania adresu
  pInfoKomputer :PHostEnt;
begin
//adujemy bibliotek Winsock
if inicjacja then
  begin
  wVersionRequested := MAKEWORD(1,0);
  WSAStartup(wVersionRequested,wsaData);
  end;

//Sprawdzamy informacje o komputerze
pInfoKomputer:=gethostbyname(PChar(nazwaKomputera));
if pInfoKomputer<>nil
  then
  begin
  nazwaKomputera:=String(pInfoKomputer^.h_Name);
  //Konwertujemy adres IP protokou IPv4 na acuch z kropkami
  Result:=String(inet_ntoa(PInAddr(pInfoKomputer^.h_addr_list^)^));
  end
  else ShowMessage('Pobranie adresu IP komputera nie powiodo si');

//Zwalniamy Winsock
if inicjacja then
  begin
  WSACleanup;
  end;
end;

function NazwaDNS(adresIP :String;inicjacja :Boolean = True) :String;
var
  //Biblioteka Winsock
  wVersionRequested:WORD;
  wsaData:TWSAData;

  pInfoKomputer :PHostEnt;
  dwAdresIP :Cardinal;
begin
//adujemy bibliotek Winsock
if inicjacja then
  begin
  wVersionRequested := MAKEWORD(1,0);
  WSAStartup(wVersionRequested,wsaData);
  end;

//Sprawdzamy informacje o komputerze
dwAdresIP:=inet_addr(PChar(adresIP));
pInfoKomputer:=GetHostByAddr(@dwAdresIP,SizeOf(Cardinal),AF_INET);
if pInfoKomputer<>nil
  then Result:=StrPas(pInfoKomputer^.h_Name)
  else ShowMessage('Pobranie nazwy komputera nie powiodo si');

//Zwalniamy Winsock
if inicjacja then
  begin
  WSACleanup;
  end;
end;


procedure TForm1.FormCreate(Sender: TObject);
var
  //Biblioteka Winsock
  wsaData:TWSAData;
begin
//adujemy bibliotek Winsock
WSAStartup(MAKEWORD(1,0),wsaData);

Button2Click(nil);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//Zwalniamy Winsock
WSACleanup;
end;

procedure TForm1.Button1Click(Sender: TObject);
var nazwaKomputera :String;
begin
if Length(Edit1.Text)=0 then Exit;
if (Edit1.Text[1]>='0') and (Edit1.Text[1]<='9') //adres IP czy nazwa DNS
  then Edit2.Text:=NazwaDNS(Edit1.Text,False)
  else
  begin
  nazwaKomputera:=Edit1.Text; //aby przekazac TCaption do AdresIP
  Edit2.Text:=AdresIP(nazwaKomputera,False);
  Edit1.Text:=nazwaKomputera;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  cstr :array[0..MAX_COMPUTERNAME_LENGTH] of Char;
  cstr_rozmiar :Cardinal;
begin
//Pobieramy nazw lokalnego komputera
GetComputerName(cstr,cstr_rozmiar);
Edit1.Text:=cstr;

//Pobieramy IP lokalnego komputera
Button1Click(nil);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key=13 then Button1Click(nil);
end;

end.
